<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Generic extends CI_Controller {
class Generic_extra extends AccessTemplate {
	
	public function __construct(){
		parent::__construct();
		$this->load->model('api_seatplans_model', 'seatplans');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_transaction_model', 'transaction');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_ticket_types_model', 'ticket_types');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');
		$this->load->model('api_bcode_model', 'bcode');
		$this->load->database('default',true); 
		//$this->load->model('api_error_model', 'error');
		$this->load->model('api_authentication_model', 'authentication');
	}
	
	  
	var $errorMessage = array (
		'ER:00' => 'Incomplete/Invalid Parameters.',
		'ER:01' => 'Invalid access.',
		'ER:02' => 'Inactive KEY',
		'ER:04' => 'In',
		'ER:05' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		'ER:06' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		);
	
 
	function register_online(){

	$livetoken = $this->input->get_post('livetoken');
	$appcode = $this->input->get_post('appcode');

	//Check if parameters are empty
	if(!$appcode){
	// $data['content'] = 'ERROR: No AppCode Provided';
	$this->promptError('ER:01:03');
	}
	elseif(!$livetoken){
	// $data['content'] = 'ERROR: No LiveToken Provided';
	$this->promptError('ER:01:04');
	}else{
		
		////Checks the existence of $appcode && $livetoken
		if (!$this->authentication->validatesession($appcode,$livetoken))
		{		
			// $data['content'] = 'Invalid  Key Pair';}
			$this->promptError('ER:02:02');
		}
		//Check if Expired..if not yet expired..if not...
		elseif($this->authentication->checksessionexpiration($appcode,$livetoken))
		{ 
			// $data['content'] = 'LiveToken Expired';}
			$this->promptError('ER:03:01');
		}
		else{

			$this->load->helper('email'); 
			  
			$customer_firstname = $this->input->get_post('customer_firstname');
			$customer_middle = $this->input->get_post('customer_middle');
			$customer_lastname = $this->input->get_post('customer_lastname');
			$customer_birthdate = $this->input->get_post('customer_birthdate');
			$customer_gender = $this->input->get_post('customer_gender');
			$customer_address = $this->input->get_post('customer_address');
			$customer_email = $this->input->get_post('customer_email');
			$customer_mobile = $this->input->get_post('customer_mobile');
			$tsize = $this->input->get_post('tsize');
			$ticketID = $this->input->get_post('ticketID');
			$branch = $this->input->get_post('branchID');
			$category = $this->input->get_post('categoryID');
			$event = $this->input->get_post('eventID');
			 
			 
			 
			if(!trim($customer_firstname))
				{
				// $customer_firstname = 'ERROR: No First Name Provided';
				$this->promptError('ER:04:04');
				}
				
				//Check LastName
			elseif(!trim($customer_lastname))
				{ 
				// $customer_lastname = 'ERROR: No Last Name Provided';
				$this->promptError('ER:04:05');
				}	
				
				
			//Check Date..Date should be in YYYY-MM-DD
			elseif (!$customer_birthdate)
				{
				// $customer_birthdate = 'ERROR: No Birth Date Provided';
				$this->promptError('ER:04:06');
				}
					
			//Returns TRUE if date format = YYYY-MM-DD
			elseif(!$this->authentication->isValidDate($customer_birthdate))
				{
				// $customer_birthdate = 'ERROR: Invalid date format';
				$this->promptError('ER:04:07');
				} 
				
			//Check mobile
			elseif(!trim($customer_mobile))
				{ 
				// $customer_mobile = 'ERROR: No Mobile Number Provided';
				$this->promptError('ER:04:08');
				} 	
				
				
			elseif(!trim($customer_address))
			{ 
			// $customer_mobile = 'ERROR: No Address Provided';
				$this->promptError('ER:04:24');
			} 	
				
				
					
		 
			//Check existing mobile number		
			elseif($this->check_mobile(trim($customer_mobile)))
			{
			
			// $customer_mobile = 'ER:04:02' => 'Mobile Number Already Used',
			$this->promptError('ER:04:02');
			} 
			 
			 
			//Check if ther is a provided email
			elseif(!trim($customer_email))
			{ 
				// $customer_email = 'ERROR: No Email Provided';
				$this->promptError('ER:04:10');
			}
				
			//Check if email Adress string is valid
			elseif(!valid_email(trim($customer_email)))
			{ 
				// $customer_email = 'ERROR: Invalid Email Format';
				$this->promptError('ER:04:09');
			}
			
			elseif(!$ticketID)
			{  
				$this->promptError('ER:04:25');
			}
			
			elseif(!$this->check_ticket(trim($ticketID),$event))
			{  
				$this->promptError('ER:04:26');
			} 
			
			else{		
						$data = array( 
						'customer_firstname'		=> $customer_firstname,
						'customer_middlename'		=> $customer_middle,
						'customer_lastname'			=> $customer_lastname, 
						'customer_birthdate'		=> $customer_birthdate,
						'customer_gender'			=> $customer_gender,  
						'customer_address1'			=> $customer_address, 
						'customer_mobile'			=> $customer_mobile,
						'customer_email'			=> $customer_email, 
						'customer_tsize'			=> $tsize, 
						'customer_ticketID'			=> $ticketID,
						'customer_branch_pickup'	=> $branch,
						'customer_run_category'		=> $category,
						'customer_event_id'			=> $event,
					);
					
				
					// insert to db
					$this->db->set($data);
					$this->db->insert('online_customers');
					
					
					$xml = '<result>Registration Succesful</result><id>'. $this->db->insert_id() . '</id>';
					foreach ($data as $key=>$value) 
					{
						 
						 
								$xml = $xml . '<' .  substr($key, 9)  .'>' . $value . '</' . substr($key, 9). '>';
							 
						 
					}	
					$data['content'] = $xml;
					$this->load->view("register_online_xml", $data);
		
				}
			}
			
			
		}
	}
		
	
	function check_ticket($ticket_id = FALSE, $event_id = false)
	{
		// check if username exists
		$this->db->where('ticket_id', $ticket_id);
		$this->db->where('ticket_event_id',$event_id);
		$this->db->where('ticket_status','done');
		$query = $this->db->get('tickets');
		
		return ($query->num_rows() > 0) ? true : false;
	}
	
	
 
	function check_mobile($mobileNumber=false){
		$exist = false;
		$dbAccess = $this->load->database('default',true);
		$dbAccess->where("customer_mobile", $mobileNumber);
		$query = $dbAccess->get('online_customers');
			
		if ($query->num_rows() > 0)
			{
			$exist = true;
			}
		return $exist;
		
	}

		
	   
	function _email_check($str)
	{
		$email_exists = $this->customers->is_email_exist($str);
		if ($email_exists)
		{
			$this->form_validation->set_message('_email_check', "Email address is already registered");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function _ticket_check($str)
	{
		$ticket_exists = $this->online->is_ticket_exist($str);
		if (!$ticket_exists)
		{
			$this->form_validation->set_message('_ticket_check', "Ticket ID is not valid for this event");
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	//Checks the existence of $appcode && $livetoken ..Returns TRUE if exists
			function validatesession($appcode=false,$livetoken=false){
				$exists = false;
				
				$dbAccess = $this->load->database('default',true);
				$dbAccess->select("api_session_id");
				$dbAccess->where("api_apppcode", $appcode);
				$dbAccess->where("api_livetoken",  $livetoken);
				$query = $dbAccess->get('api_sessions');

					if ($query->num_rows() > 0)
					{
					$exists = True;
					}
					
				return $exists;
			}
			
	
}



